﻿//////////////////////////////////////////////
// PngEncoder.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Includes ---------------------------------

// nkImages
#include "../Data/AlignmentDescriptor.h"
#include "../Data/Image.h"
#include "../Data/ImageView.h"

#include "../Dll/DllDefines.h"

// nkMemory
#include <NilkinsMemory/Containers/Buffer.h>
#include <NilkinsMemory/Containers/BufferView.h>

/// Class ------------------------------------

namespace nkImages
{
	class DLL_IMAGES_EXPORT PngEncoder final
	{
		public :

			// Compression
			//static nkMemory::Buffer encode (const ImageView& image, const JpgCompressionSettings& settings = JpgCompressionSettings()) ;

			// Decompression
			static bool canDecode (nkMemory::BufferView<unsigned char> data) ;
			static Image decode (nkMemory::BufferView<unsigned char> data, const AlignmentDescriptor& alignmentDescriptor = AlignmentDescriptor()) ;
	} ;
}